<?php

namespace App\Http\Controllers\Admin;  // ✅ اضافه کردن \Admin
use App\Models\Test;
use Illuminate\Http\Request;
use App\Models\Question; 
use App\Http\Controllers\Controller;
class AdminTestController extends Controller
{
    public function index(){
        $tests=Test::all();

        return view ('admin.tests.index',compact('tests'));
    }
    public function create() 
    {
        return view('admin.tests.create'); 
    } 

    public function store(Request $request)
    {
        $validated= $request->validate([
            'title'=>'required|string|max:255',
            'description'=>'nullable|string|max:700',
            'is-active'=>'boolean',
        ]);
        Test::create([
            'title'=>$validated['title'],
            'description'=>$validated['description'] ?? null,
            'is-active'=>$validated['is-active'] ?? false, 

        ]);

        return redirect()->route('admin.tests.index')->with('succes','تست با موفقیت ساخته شد');

        
            
            
    }

    
    public function edit($id) 
    {
        $test = Test::findOrFail($id);  
        
        return view('admin.tests.edit', compact('test'));  
        
    }

    public function update(Request $request,$id){
        
        
    
        $validated= $request->validate([
            'title'=>'required|string|max:255',
            'description'=>'nullable|string|max:700',
            'is-active'=>'boolean',
        ]);
        
        $test=Test::findorFail($id);

        $test->update([
        'title' => $validated['title'],
        'description' => $validated['description'] ?? null,
        'is_active' => $request->has('is_active') ? true : false,
    ]);
        return redirect()->route('admin.tests.index')->with('success', 'تست با موفقیت ویرایش شد');


    }

    public function destroy($id){
        $test=Test::findorFail($id);
        $test->delete();
        return redirect()->route('admin.tests.index')->with('success', 'تست با موفقیت حذف شد');
    }

}
