<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Formula extends Model
{

    use HasFactory;

    protected $fillable = [
        'test_id',
        'name',
        'code',              // ✅ اضافه شد
        'type',              // ✅ اضافه شد
        'priority',          // ✅ اضافه شد
        'formula_expression',
        'formula_config',
        'variables',         // ✅ اضافه شد
        'is_active',
        'order',
    ];

    protected $casts = [
        'formula_config' => 'array',
        'variables' => 'array',      // ✅ اضافه شد (برای JSON)
        'is_active' => 'boolean',
        'priority' => 'integer',     // ✅ اضافه شد
    ];


    public function questions(): HasMany
    {
        return $this->hasMany(Question::class);
    }

    public function test(): BelongsTo
    {
        return $this->belongsTo(Test::class);
    }
}
