<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class FormulaResult extends Model
{
    protected $fillable = [
        'test_id',
        'user_id',
        'attempt_id',
        'formula_id',
        'formula_code',
        'input_values',
        'expression_snapshot',
        'result_type',
        'result_value',
        'execution_time',
    ];

    protected $casts = [
        'input_values' => 'array',  // ← تبدیل خودکار JSON به آرایه
        'execution_time' => 'decimal:6',
    ];
}
