<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;


class Question extends Model
{
    use HasFactory;

    protected $fillable = [
        'test_id',
        'type',
        'text',
        'order',
        'is_required',
        'formula_expression',  
        'formula_config',
    ];

    protected $casts = [
        'is_required' => 'boolean',
        'order' => 'integer',
         'formula_config' => 'array',
    ];

    public function test(): BelongsTo
    {
        return $this->belongsTo(Test::class);
    }

    public function options(): HasMany
    {
        return $this->hasMany(Option::class);
    }

    public function formula(): BelongsTo
    {
        return $this->belongsTo(Formula::class);
    }

    public function weight(): HasOne
{
    return $this->hasOne(QuestionWeight::class);
}
}