<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
   public function up(): void
{
    Schema::create('answers', function (Blueprint $table) {
        $table->id();
        
        // اصلاحیه: نام جدول را دستی وارد می‌کنیم
        $table->foreignId('attempt_id')->constrained('test_attempts')->onDelete('cascade');
        
        $table->foreignId('question_id')->constrained()->onDelete('cascade');
        $table->foreignId('option_id')->nullable()->constrained()->onDelete('set null');
        $table->text('text_answer')->nullable();
        $table->timestamps();

        $table->unique(['attempt_id', 'question_id']);
    });
}

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('answers');
    }
};
