<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('question_weights', function (Blueprint $table) {
            $table->id();
            $table->foreignId('question_id')->constrained()->onDelete('cascade');
            $table->decimal('weight', 5, 2)->default(1.00); // وزن پیش‌فرض ۱
            $table->timestamps();
            
            // هر سوال فقط یک وزن دارد
            $table->unique('question_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('question_weights');
    }
};