<?php

namespace Database\Seeders;

use App\Models\Test;
use App\Models\Question;
use App\Models\Option;
use App\Models\User;
use App\Models\QuestionWeight;
use Illuminate\Database\Seeder;

class InitialTestSeeder extends Seeder
{
    public function run(): void
    {
        // ۱. ساخت یک کاربر تستی (برای جلوگیری از خطای کلید خارجی)
        $user = User::first();
        if (!$user) {
            $user = User::create([
                'name' => 'Test User',
                'email' => 'test@example.com',
                'password' => bcrypt('password'),
            ]);
        }

        // ۲. ساخت یک تست نمونه
        $test = Test::create([
            'title' => 'تست اضطراب بک (نمونه)',
            'description' => 'این یک تست نمونه برای بررسی عملکرد سیستم است.',
            'is_active' => true,
        ]);

        // ۳. ساخت سوالات برای تست
        $question1 = Question::create([
            'test_id' => $test->id,
            'type' => 'multiple_choice',
            'text' => 'چقدر احساس عصبی بودن می‌کنید؟',
            'order' => 1,
            'is_required' => true,
        ]);

        $question2 = Question::create([
            'test_id' => $test->id,
            'type' => 'multiple_choice',
            'text' => 'آیا احساس خطر می‌کنید؟',
            'order' => 2,
            'is_required' => true,
        ]);

        $question3 = Question::create([
            'test_id' => $test->id,
            'type' => 'descriptive',
            'text' => 'توضیحات تکمیلی خود را بنویسید.',
            'order' => 3,
            'is_required' => false,
        ]);

        // ۴. ساخت گزینه‌ها برای سوالات چندگزینه‌ای
        // سوال ۱: ۴ گزینه (آیدی‌های ۱ تا ۴)
        Option::create(['question_id' => $question1->id, 'text' => 'اصلاً']);
        Option::create(['question_id' => $question1->id, 'text' => 'کمی']);
        Option::create(['question_id' => $question1->id, 'text' => 'زیاد']);
        Option::create(['question_id' => $question1->id, 'text' => 'خیلی زیاد']);

        // سوال ۲: ۲ گزینه (آیدی‌های ۵ و ۶)
        Option::create(['question_id' => $question2->id, 'text' => 'بله']);
        Option::create(['question_id' => $question2->id, 'text' => 'خیر']);

        // سوال ۱
        Option::create(['question_id' => $question1->id, 'text' => 'اصلاً', 'score_value' => 0]);
        Option::create(['question_id' => $question1->id, 'text' => 'کمی', 'score_value' => 1]);
        Option::create(['question_id' => $question1->id, 'text' => 'زیاد', 'score_value' => 2]);
        Option::create(['question_id' => $question1->id, 'text' => 'خیلی زیاد', 'score_value' => 3]);

        // سوال ۲
        Option::create(['question_id' => $question2->id, 'text' => 'خیر', 'score_value' => 0]);
        Option::create(['question_id' => $question2->id, 'text' => 'بله', 'score_value' => 1]);
    
    QuestionWeight::create(['question_id' => $question1->id, 'weight' => 1.50]);
    QuestionWeight::create(['question_id' => $question2->id, 'weight' => 0.50]);
    QuestionWeight::create(['question_id' => $question3->id, 'weight' => 1.00]);}
}