<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>نتایج فرمول‌ها</title>
    <style>
        body { font-family: Tahoma; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: #fff; padding: 20px; border-radius: 8px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 10px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #f8f8f8; }
        .badge { padding: 4px 8px; border-radius: 4px; font-size: 11px; }
        .badge-code { background: #cce5ff; color: #004085; }
        .badge-success { background: #d4edda; color: #155724; }
        .text-success { color: #28a745; font-weight: bold; }
        .text-error { color: #dc3545; }
        a { color: #007bff; }
    </style>
</head>
<body>
<div class="container">
    <h1>نتایج فرمول‌های تست: {{ $test->title }}</h1>

    <h2>لیست فرمول‌ها</h2>
    <table>
        <thead>
        <tr>
            <th>کد</th>
            <th>نام</th>
            <th>فرمول</th>
            <th>نتیجه</th>
            <th>وضعیت</th>
        </tr>
        </thead>
        <tbody>
        @forelse($formulas as $formula)
            @php $result = $latestResults[$formula->code]->first() ?? null; @endphp
            <tr>
                <td><span class="badge badge-code">{{ $formula->code }}</span></td>
                <td>{{ $formula->name }}</td>
                <td style="font-family: monospace;">{{ $formula->formula_expression }}</td>
                <td>
                    @if($result && $result->result_value !== null)
                        <span class="text-success">{{ $result->result_value }}</span>
                    @elseif($result)
                        <span class="text-error">خطا</span>
                    @else
                        <span style="color: #999;">هنوز اجرا نشده</span>
                    @endif
                </td>
                <td>
                    @if($result && $result->result_value !== null)
                        <span class="badge badge-success">✅ موفق</span>
                    @elseif($result)
                        <span class="badge badge-error" style="background: #f8d7da; color: #721c24;">❌ خطا</span>
                    @else
                        <span class="badge" style="background: #fff3cd; color: #856404;">⏳ در انتظار</span>
                    @endif
                </td>
            </tr>
        @empty
            <tr><td colspan="5" style="text-align: center; padding: 20px;">هیچ فرمولی وجود ندارد</td></tr>
        @endforelse
        </tbody>
    </table>

    @if($attempts->count() > 0)
        <h2 style="margin-top: 30px;">اجراهای اخیر</h2>
        <table>
            <thead>
            <tr>
                <th>ID اجرا</th>
                <th>شرکت‌کننده</th>
                <th>نمره کل</th>
                <th>عملیات</th>
            </tr>
            </thead>
            <tbody>
            @foreach($attempts as $attempt)
                <tr>
                    <td>{{ $attempt->id }}</td>
                    <td>{{ $attempt->participant_name }}</td>
                    <td>{{ $attempt->total_score }}</td>
                    <td>
                        <a href="/tests/{{ $test->id }}/formula-results/{{ $attempt->id }}">مشاهده جزئیات →</a>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    @endif

    <p style="margin-top: 20px;"><a href="/tests">← بازگشت به لیست تست‌ها</a></p>
</div>
</body>
</html>
