<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>جزئیات کامل تست - اجرای #{{ $attempt->id }}</title>
    <style>
        * { box-sizing: border-box; }
        body { font-family: Tahoma, Vazir, sans-serif; background: #f5f5f5; padding: 20px; margin: 0; line-height: 1.6; }
        .container { max-width: 1400px; margin: 0 auto; }
        .section { background: #fff; padding: 20px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .section-title { font-size: 18px; font-weight: bold; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #007bff; color: #333; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .header h1 { margin: 0; font-size: 22px; }
        .btn { display: inline-block; padding: 8px 16px; background: #6c757d; color: #fff; border-radius: 4px; text-decoration: none; }
        .btn:hover { background: #5a6268; text-decoration: none; }

        /* جدول‌ها */
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; font-weight: bold; color: #333; }
        tr:hover { background: #f9f9f9; }

        /* Badgeها */
        .badge { padding: 4px 10px; border-radius: 4px; font-size: 11px; display: inline-block; }
        .badge-code { background: #cce5ff; color: #004085; }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-error { background: #f8d7da; color: #721c24; }

        /* رنگ‌ها */
        .text-success { color: #28a745; font-weight: bold; }
        .text-error { color: #dc3545; }
        .text-muted { color: #666; }
        .text-primary { color: #007bff; }

        /* اطلاعات شرکت‌کننده */
        .info-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; }
        .info-item { background: #f8f9fa; padding: 12px; border-radius: 6px; }
        .info-item small { display: block; color: #666; font-size: 12px; margin-bottom: 4px; }
        .info-item strong { font-size: 14px; color: #333; }

        /* سوالات */
        .question-card { background: #fafafa; border: 1px solid #e0e0e0; border-radius: 6px; padding: 15px; margin-bottom: 12px; }
        .question-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .question-number { background: #007bff; color: #fff; width: 28px; height: 28px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; }
        .question-score { font-size: 13px; color: #28a745; font-weight: bold; }
        .question-text { font-size: 14px; margin-bottom: 10px; color: #333; }
        .answer-detail { font-size: 13px; color: #666; }
        .answer-detail span { color: #007bff; font-weight: bold; }

        /* فرمول‌ها */
        .formula-card { background: #fff; border: 1px solid #e0e0e0; border-radius: 6px; padding: 15px; margin-bottom: 12px; }
        .formula-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .formula-expression { font-family: 'Courier New', monospace; background: #f5f5f5; padding: 10px; border-radius: 4px; font-size: 13px; direction: ltr; text-align: left; margin: 10px 0; }
        .formula-input { font-size: 12px; color: #666; margin: 8px 0; }
        .formula-result { font-size: 16px; font-weight: bold; }

        /* اسکرول افقی برای جدول‌های بزرگ */
        .table-responsive { overflow-x: auto; }
    </style>
</head>
<body>
<div class="container">
    {{-- هدر صفحه --}}
    <div class="header">
        <div>
            <h1>📊 جزئیات کامل تست</h1>
            <p style="margin: 5px 0 0 0; color: #666;">
                تست: {{ $test->title }} | اجرای شماره: {{ $attempt->id }}
            </p>
        </div>
        <a href="/tests/{{ $test->id }}/formula-results" class="btn">← بازگشت به لیست</a>
    </div>

    {{-- اطلاعات شرکت‌کننده --}}
    <div class="section">
        <div class="section-title">👤 اطلاعات شرکت‌کننده</div>
        <div class="info-grid">
            <div class="info-item">
                <small>نام</small>
                <strong>{{ $attempt->participant_name ?? '-' }}</strong>
            </div>
            <div class="info-item">
                <small>شماره تماس</small>
                <strong>{{ $attempt->participant_phone ?? '-' }}</strong>
            </div>
            <div class="info-item">
                <small>نمره کل سوالات</small>
                <strong class="text-success">{{ $attempt->total_score }}</strong>
            </div>
            <div class="info-item">
                <small>تاریخ اجرا</small>
                <strong>{{ $attempt->created_at?->format('Y/m/d H:i') ?? '-' }}</strong>
            </div>
        </div>
    </div>

    {{-- سوالات و پاسخ‌ها --}}
    <div class="section">
        <div class="section-title">📝 سوالات و پاسخ‌های کاربر</div>
        <div class="table-responsive">
            <table>
                <thead>
                <tr>
                    <th style="width: 50px;">#</th>
                    <th>سوال</th>
                    <th>پاسخ کاربر</th>
                    <th>امتیاز سوال</th>
                </tr>
                </thead>
                <tbody>
                @forelse($answers as $index => $answer)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ $answer->question->text ?? 'سوال حذف شده' }}</td>
                        <td>
                            @if($answer->option_id)
                                <span class="text-primary">
                                    {{ $answer->question->options->firstWhere('id', $answer->option_id)->text ?? 'گزینه حذف شده' }}
                                </span>
                            @elseif($answer->text_answer)
                                <span class="text-muted">{{ $answer->text_answer }}</span>
                            @else
                                <span class="text-error">بدون پاسخ</span>
                            @endif
                        </td>
                        <td>
                            @if($answer->option_id)
                                @php
                                    $option = $answer->question->options->firstWhere('id', $answer->option_id);
                                    $score = $option?->score_value ?? 0;
                                @endphp
                                <span class="{{ $score > 0 ? 'text-success' : 'text-muted' }}">
                                    {{ $score }}
                                </span>
                            @else
                                <span class="text-muted">0</span>
                            @endif
                        </td>
                    </tr>
                @empty
                    <tr><td colspan="4" style="text-align: center; padding: 20px; color: #666;">پاسخی یافت نشد</td></tr>
                @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- نتایج فرمول‌ها --}}
    <div class="section">
        <div class="section-title">🧮 محاسبات فرمول‌ها</div>

        @forelse($results as $index => $result)
            <div class="formula-card">
                <div class="formula-header">
                    <div>
                        <span class="badge badge-code">{{ $result->formula_code }}</span>
                        <span style="margin-right: 10px; color: #666;">
                        {{ $formulas[$result->formula_id]->name ?? 'فرمول نامشخص' }}
                    </span>
                    </div>
                    <div>
                        @if($result->result_value !== null)
                            <span class="badge badge-success">✅ موفق</span>
                        @else
                            <span class="badge badge-error">❌ خطا</span>
                        @endif
                    </div>
                </div>

                <div class="formula-expression">
                    <strong>معادله:</strong> {{ $result->expression_snapshot }}
                </div>

                <div class="formula-input">
                    <strong>مقادیر ورودی:</strong>
                    <code style="direction: ltr; display: inline-block;">
                        {{ json_encode($result->input_values ?? [], JSON_UNESCAPED_UNICODE) }}
                    </code>
                </div>

                <div class="formula-result">
                    <strong>نتیجه نهایی:</strong>
                    @if($result->result_value !== null)
                        <span class="text-success" style="font-size: 20px;">
                        {{ $result->result_value }}
                    </span>
                        <span class="text-muted" style="font-size: 12px;">({{ $result->result_type }})</span>
                    @else
                        <span class="text-error">محاسبه نشد</span>
                    @endif
                </div>
            </div>
        @empty
            <p style="text-align: center; color: #666; padding: 20px;">هیچ نتیجه‌ای برای این اجرا یافت نشد</p>
        @endforelse
    </div>
</div>
</body>
</html>
