<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فرمول‌های تست {{ $test->title }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: radial-gradient(circle at top, #2a0000 0%, #0a0a0f 60%, #000 100%);
            min-height: 100vh;
            padding: 40px 20px;
            color: #c7c7c7;
            overflow-x: hidden;
        }
        body::after {
            content: ""; position: fixed; inset: 0;
            background: rgba(0,0,0,0.35); pointer-events: none; z-index: 1;
        }
        .container { max-width: 1000px; margin: 0 auto; position: relative; z-index: 5; }
        h1 { text-align: center; font-size: 26px; color: #ff5c5c; letter-spacing: 2px; margin-bottom: 30px; text-shadow: 0 0 15px rgba(255, 92, 92, 0.4); }

        .test-info {
            background: rgba(80, 0, 0, 0.3);
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-right: 3px solid #ff5c5c;
        }
        .test-info h2 { color: #ff8c8c; margin-bottom: 8px; font-size: 18px; }
        .test-info p { color: #999; font-size: 13px; }

        .btn {
            display: inline-block; padding: 10px 20px; border-radius: 4px;
            text-decoration: none; font-size: 12px; letter-spacing: 1px;
            transition: all 0.25s ease; border: 1px solid transparent; margin: 3px;
        }
        .btn-primary { background: #1a1a1a; color: #ff5c5c; border-color: #ff5c5c; }
        .btn-primary:hover { background: #ff5c5c; color: #000; }
        .btn-warning { background: #2a241b; color: #ffcc88; border: 1px solid #554; font-size: 11px; padding: 5px 10px; }
        .btn-danger { background: #2a0000; color: #ff8c8c; border: 1px solid #660000; font-size: 11px; padding: 5px 10px; }
        .btn-danger:hover { background: #660000; }
        .btn-secondary { background: #1a1a1a; color: #aaa; border: 1px solid #444; font-size: 11px; padding: 5px 10px; }

        table {
            width: 100%; border-collapse: collapse;
            background: rgba(0, 0, 0, 0.6);
            box-shadow: inset 0 0 40px rgba(255, 0, 0, 0.08), 0 20px 60px rgba(0, 0, 0, 0.9);
            margin-top: 20px;
        }
        thead { background: rgba(80, 0, 0, 0.6); }
        th { padding: 14px; text-align: right; color: #ff8c8c; font-weight: normal; border-bottom: 1px solid rgba(255,255,255,0.05); font-size: 13px; }
        td { padding: 14px; color: #b0b0b0; border-bottom: 1px solid rgba(255,255,255,0.04); font-size: 13px; }
        tr:hover { background: rgba(255, 0, 0, 0.05); }

        .status-badge {
            padding: 3px 10px; border-radius: 12px; font-size: 11px; font-weight: bold;
        }
        .status-active { background: rgba(159, 211, 199, 0.2); color: #9fd3c7; border: 1px solid #355; }
        .status-inactive { background: rgba(100, 100, 100, 0.2); color: #888; border: 1px solid #444; }

        .empty-state { text-align: center; padding: 80px 20px; color: #777; }
        .empty-state h2 { color: #ff5c5c; font-weight: normal; margin-bottom: 10px; }

        .alert {
            padding: 12px; margin-bottom: 20px;
            background: rgba(255, 0, 0, 0.08);
            border-right: 4px solid #ff5c5c;
            color: #ffb3b3;
            font-size: 13px;
        }

        .back-link {
            display: inline-block; color: #ff5c5c; margin-bottom: 20px;
            text-decoration: none; font-size: 13px;
        }
        .back-link:hover { text-decoration: underline; }

        .actions { display: flex; gap: 5px; flex-wrap: wrap; }
    </style>
</head>
<body>
<div class="container">
    {{-- لینک بازگشت به لیست سوالات --}}
    <a href="{{ route('admin.questions.index', $test->id) }}" class="back-link">
        ← بازگشت به لیست سوالات
    </a>

    <h1>📐 فرمول‌های تست</h1>

    {{-- اطلاعات تست --}}
    <div class="test-info">
        <h2>{{ $test->title }}</h2>
        <p>{{ Str::limit($test->description, 100) ?? 'بدون توضیحات' }}</p>
        <p style="margin-top: 8px; color: #ff5c5c; font-size: 12px;">
            تعداد فرمول‌ها: <strong>{{ $formulas->count() }}</strong>
        </p>
    </div>

    @if(session('success'))
        <div class="alert">✅ {{ session('success') }}</div>
    @endif

    <div style="margin-bottom: 20px;">
        {{-- دکمه افزودن فرمول جدید --}}
        <a href="{{ route('admin.formulas.create', $test->id) }}" class="btn btn-primary">
            ➕ افزودن فرمول جدید
        </a>
        <a href="{{ route('admin.questions.index', $test->id) }}" class="btn btn-secondary">
            📝 سوالات
        </a>
    </div>

    @if($formulas->count() > 0)
        <table>
            <thead>
            <tr>
                <th>ترتیب</th>
                <th>نام فرمول</th>
                <th>متغیرها</th>
                <th>وضعیت</th>
                <th>عملیات</th>
            </tr>
            </thead>
            <tbody>
            @foreach($formulas as $formula)
                <tr>
                    <td>{{ $formula->order ?? '-' }}</td>
                    <td style="color: #fff;">{{ Str::limit($formula->name, 50) }}</td>
                    <td>
                        @if($formula->variables)
                            <span style="color: #00d9ff;">{{ Str::limit($formula->variables, 30) }}</span>
                        @else
                            <span style="color: #666;">-</span>
                        @endif
                    </td>
                    <td>
                        @if($formula->is_active)
                            <span class="status-badge status-active">فعال</span>
                        @else
                            <span class="status-badge status-inactive">غیرفعال</span>
                        @endif
                    </td>
                    <td>
                        <div class="actions">
                            {{-- ویرایش فرمول --}}
                            <a href="{{ route('admin.formulas.edit', [$test->id, $formula->id]) }}"
                               class="btn btn-warning">✏️ ویرایش</a>

                            {{-- حذف فرمول --}}
                            <form action="{{ route('admin.formulas.destroy', [$test->id, $formula->id]) }}"
                                  method="POST" style="display: inline;"
                                  onsubmit="return confirm('آیا از حذف این فرمول مطمئن هستید؟')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">🗑️ حذف</button>
                            </form>
                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    @else
        <div class="empty-state">
            <h2>هیچ فرمولی وجود ندارد</h2>
            <p>برای شروع، اولین فرمول را اضافه کنید</p>
            <br>
            <a href="{{ route('admin.formulas.create', $test->id) }}" class="btn btn-primary">
                ➕ افزودن اولین فرمول
            </a>
        </div>
    @endif
</div>
</body>
</html>
