<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>افزودن سوال جدید - {{ $test->title }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: radial-gradient(circle at top, #2a0000 0%, #0a0a0f 60%, #000 100%);
            min-height: 100vh;
            padding: 40px 20px;
            color: #c7c7c7;
        }
        .container { max-width: 800px; margin: 0 auto; }
        h1 { color: #ff5c5c; margin-bottom: 30px; text-align: center; }
        
        .test-info {
            background: rgba(80, 0, 0, 0.3);
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-right: 3px solid #ff5c5c;
        }
        .test-info h2 { color: #ff8c8c; font-size: 16px; }
        
        .form-group { margin-bottom: 25px; }
        label { display: block; color: #ff8c8c; margin-bottom: 8px; font-weight: bold; }
        input[type="text"], input[type="number"], textarea, select {
            width: 100%;
            padding: 12px;
            border-radius: 4px;
            border: 1px solid rgba(255,255,255,0.2);
            background: rgba(255,255,255,0.05);
            color: #fff;
            font-size: 14px;
        }
        textarea { min-height: 100px; resize: vertical; }
        
        .radio-group {
            display: flex;
            gap: 20px;
            padding: 12px;
            background: rgba(255,255,255,0.05);
            border-radius: 4px;
        }
        .radio-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 0;
            color: #c7c7c7;
            font-weight: normal;
            cursor: pointer;
        }
        .radio-group input { width: auto; }
        
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px;
            background: rgba(255,255,255,0.05);
            border-radius: 4px;
        }
        .checkbox-group input { width: auto; }
        .checkbox-group label { margin: 0; color: #c7c7c7; font-weight: normal; }
        
        .options-section {
            margin-top: 20px;
            padding: 20px;
            background: rgba(0, 217, 255, 0.05);
            border-radius: 8px;
            border: 1px dashed #00d9ff;
            display: none;
        }
        .options-section.active { display: block; }
        .options-section h3 { color: #00d9ff; margin-bottom: 15px; font-size: 16px; }
        
        .option-item {
            display: flex;
            gap: 10px;
            margin-bottom: 10px;
            align-items: center;
        }
        .option-item input { flex: 1; }
        .option-item input[type="number"] { width: 80px; flex: none; }
        .btn-remove {
            background: #ff4444;
            color: #fff;
            border: none;
            padding: 8px 12px;
            border-radius: 4px;
            cursor: pointer;
        }
        
        .btn-add {
            background: transparent;
            color: #00d9ff;
            border: 1px solid #00d9ff;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 10px;
        }
        .btn-add:hover { background: rgba(0, 217, 255, 0.1); }
        
        .btn-group { display: flex; gap: 15px; margin-top: 30px; }
        .btn {
            flex: 1;
            padding: 14px;
            border-radius: 4px;
            border: none;
            font-size: 14px;
            font-weight: bold;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
        }
        .btn-primary { background: #ff5c5c; color: #000; }
        .btn-primary:hover { background: #ff3333; }
        .btn-secondary { background: rgba(255,255,255,0.1); color: #fff; }
        .btn-secondary:hover { background: rgba(255,255,255,0.2); }
        
        .error { color: #ff4444; font-size: 13px; margin-top: 5px; }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            background: rgba(255, 68, 68, 0.1);
            border-right: 4px solid #ff4444;
            color: #ff4444;
        }
        .back-link {
            display: inline-block;
            color: #ff5c5c;
            margin-bottom: 20px;
            text-decoration: none;
        }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="container">
        {{-- ✅ لینک بازگشت اصلاح شد --}}
        <a href="{{ route('admin.questions.index', $test->id) }}" class="back-link">
            ← بازگشت به لیست سوالات
        </a>
        
        <h1>➕ افزودن سوال جدید</h1>
        
        <div class="test-info">
            <h2>تست: {{ $test->title }}</h2>
        </div>

        @if($errors->any())
            <div class="alert">
                <ul style="margin: 0; padding-right: 20px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- ✅ اکشن فرم اصلاح شد --}}
        <form action="{{ route('admin.questions.store', $test->id) }}" method="POST">
            @csrf

            {{-- متن سوال --}}
            <div class="form-group">
                <label for="text">متن سوال *</label>
                <textarea id="text" name="text" required placeholder="متن سوال را اینجا بنویسید...">{{ old('text') }}</textarea>
                @error('text') <div class="error">{{ $message }}</div> @enderror
            </div>

            {{-- نوع سوال --}}
            <div class="form-group">
                <label>نوع سوال *</label>
                <div class="radio-group">
                    <label>
                        <input type="radio" name="type" value="multiple_choice" 
                               {{ old('type') == 'multiple_choice' ? 'checked' : '' }}
                               onclick="toggleOptions(true)">
                        تستی (چندگزینه‌ای)
                    </label>
                    <label>
                        <input type="radio" name="type" value="text" 
                               {{ old('type') == 'text' ? 'checked' : '' }}
                               onclick="toggleOptions(false)">
                        تشریحی
                    </label>
                </div>
                @error('type') <div class="error">{{ $message }}</div> @enderror
            </div>

            {{-- بخش گزینه‌ها --}}
            <div id="options-section" class="options-section">
                <h3>📝 گزینه‌های سوال</h3>
                <div id="options-container">
                    <div class="option-item">
                        <input type="text" name="options[0][text]" placeholder="متن گزینه ۱">
                        <input type="number" name="options[0][score_value]" placeholder="امتیاز" step="0.1">
                        <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
                    </div>
                    <div class="option-item">
                        <input type="text" name="options[1][text]" placeholder="متن گزینه ۲">
                        <input type="number" name="options[1][score_value]" placeholder="امتیاز" step="0.1">
                        <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
                    </div>
                </div>
                <button type="button" class="btn-add" onclick="addOption()">➕ افزودن گزینه</button>
            </div>

            {{-- ترتیب نمایش --}}
            <div class="form-group">
                <label for="order">ترتیب نمایش *</label>
                <input type="number" id="order" name="order" value="{{ old('order', 1) }}" min="1" required>
                @error('order') <div class="error">{{ $message }}</div> @enderror
            </div>

            {{-- اجباری بودن --}}
            <div class="form-group">
                <div class="checkbox-group">
                    <input type="checkbox" id="is_required" name="is_required" value="1" {{ old('is_required') ? 'checked' : '' }}>
                    <label for="is_required">پاسخ به این سوال اجباری باشد</label>
                </div>
            </div>

            {{-- فرمول مرتبط --}}
            @if($formulas->count() > 0)
            <div class="form-group">
                <label for="formula_id">فرمول مرتبط (اختیاری)</label>
                <select id="formula_id" name="formula_id">
                    <option value="">-- بدون فرمول --</option>
                    @foreach($formulas as $formula)
                        <option value="{{ $formula->id }}" {{ old('formula_id') == $formula->id ? 'selected' : '' }}>
                            {{ $formula->name }}
                        </option>
                    @endforeach
                </select>
                @error('formula_id') <div class="error">{{ $message }}</div> @enderror
            </div>
            @endif

            {{-- دکمه‌ها --}}
            <div class="btn-group">
                <button type="submit" class="btn btn-primary">💾 ذخیره سوال</button>
                {{-- ✅ دکمه انصراف اصلاح شد --}}
                <a href="{{ route('admin.questions.index', $test->id) }}" class="btn btn-secondary">❌ انصراف</a>
            </div>
        </form>
    </div>

    <script>
        function toggleOptions(show) {
            const section = document.getElementById('options-section');
            if (show) {
                section.classList.add('active');
            } else {
                section.classList.remove('active');
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            const selected = document.querySelector('input[name="type"]:checked');
            if (selected) {
                toggleOptions(selected.value === 'multiple_choice');
            }
        });

        function addOption() {
            const container = document.getElementById('options-container');
            const index = container.children.length;
            const div = document.createElement('div');
            div.className = 'option-item';
            div.innerHTML = `
                <input type="text" name="options[${index}][text]" placeholder="متن گزینه ${index + 1}">
                <input type="number" name="options[${index}][score_value]" placeholder="امتیاز" step="0.1">
                <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
            `;
            container.appendChild(div);
        }

        function removeOption(btn) {
            btn.parentElement.remove();
        }
    </script>
</body>
</html>