<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ویرایش سوال - {{ $test->title }}</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: radial-gradient(circle at top, #2a0000 0%, #0a0a0f 60%, #000 100%);
            min-height: 100vh;
            padding: 40px 20px;
            color: #c7c7c7;
            overflow-x: hidden;
            position: relative;
        }
        body::after {
            content: "";
            position: fixed;
            inset: 0;
            background: rgba(0,0,0,0.4);
            pointer-events: none;
            z-index: 1;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            position: relative;
            z-index: 5;
        }
        h1 {
            color: #ff3333;
            text-align: center;
            margin-bottom: 30px;
            text-shadow: 0 0 20px rgba(255, 51, 51, 0.6);
            letter-spacing: 2px;
        }
        .test-info {
            background: rgba(80, 0, 0, 0.3);
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 25px;
            border-right: 3px solid #ff3333;
        }
        .test-info h2 { color: #ff6666; font-size: 16px; }
        .form-group { margin-bottom: 25px; }
        label {
            display: block;
            color: #ff6666;
            margin-bottom: 8px;
            font-weight: bold;
        }
        input[type="text"],
        input[type="number"],
        textarea,
        select {
            width: 100%;
            padding: 12px;
            border-radius: 4px;
            border: 1px solid rgba(255, 100, 100, 0.3);
            background: rgba(0, 0, 0, 0.5);
            color: #fff;
            font-size: 14px;
        }
        input:focus, textarea:focus, select:focus {
            outline: none;
            border-color: #ff3333;
            box-shadow: 0 0 15px rgba(255, 51, 51, 0.3);
        }
        textarea { min-height: 100px; resize: vertical; }
        .radio-group {
            display: flex;
            gap: 20px;
            padding: 12px;
            background: rgba(0, 0, 0, 0.4);
            border-radius: 4px;
            border: 1px solid rgba(255, 100, 100, 0.2);
        }
        .radio-group label {
            display: flex;
            align-items: center;
            gap: 8px;
            margin: 0;
            color: #c7c7c7;
            font-weight: normal;
            cursor: pointer;
        }
        .radio-group input { width: auto; accent-color: #ff3333; }
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px;
            background: rgba(0, 0, 0, 0.4);
            border-radius: 4px;
            border: 1px solid rgba(255, 100, 100, 0.2);
        }
        .checkbox-group input { width: auto; accent-color: #ff3333; }
        .checkbox-group label { margin: 0; color: #c7c7c7; font-weight: normal; }
        .options-section {
            margin-top: 20px;
            padding: 20px;
            background: rgba(255, 0, 0, 0.05);
            border-radius: 8px;
            border: 1px dashed #ff3333;
            display: none;
        }
        .options-section.active { display: block; animation: fadeIn 0.5s ease; }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        .options-section h3 { color: #ff3333; margin-bottom: 15px; font-size: 16px; }
        .option-item {
            display: flex;
            gap: 10px;
            margin-bottom: 10px;
            align-items: center;
            animation: slideIn 0.3s ease;
        }
        @keyframes slideIn {
            from { opacity: 0; transform: translateX(-20px); }
            to { opacity: 1; transform: translateX(0); }
        }
        .option-item input { flex: 1; }
        .option-item input[type="number"] { width: 80px; flex: none; }
        .btn-remove {
            background: #660000;
            color: #ff6666;
            border: 1px solid #ff3333;
            padding: 8px 12px;
            border-radius: 4px;
            cursor: pointer;
            transition: all 0.3s;
        }
        .btn-remove:hover { background: #ff3333; color: #000; }
        .btn-add {
            background: transparent;
            color: #ff6666;
            border: 1px solid #ff3333;
            padding: 8px 16px;
            border-radius: 4px;
            cursor: pointer;
            margin-top: 10px;
            transition: all 0.3s;
        }
        .btn-add:hover { background: rgba(255, 51, 51, 0.1); }
        .btn-group { display: flex; gap: 15px; margin-top: 30px; }
        .btn {
            flex: 1;
            padding: 14px;
            border-radius: 4px;
            border: none;
            font-size: 14px;
            font-weight: bold;
            cursor: pointer;
            text-align: center;
            text-decoration: none;
            transition: all 0.3s;
        }
        .btn-primary {
            background: linear-gradient(135deg, #660000, #990000);
            color: #fff;
            border: 1px solid #ff3333;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #990000, #cc0000);
            box-shadow: 0 0 20px rgba(255, 51, 51, 0.4);
        }
        .btn-secondary {
            background: rgba(0, 0, 0, 0.5);
            color: #c7c7c7;
            border: 1px solid rgba(255, 100, 100, 0.3);
        }
        .btn-secondary:hover {
            background: rgba(50, 0, 0, 0.5);
            color: #fff;
        }
        .error { color: #ff6666; font-size: 13px; margin-top: 5px; }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            background: rgba(255, 0, 0, 0.1);
            border-right: 4px solid #ff3333;
            color: #ff6666;
        }
        .back-link {
            display: inline-block;
            color: #ff6666;
            margin-bottom: 20px;
            text-decoration: none;
            transition: all 0.3s;
        }
        .back-link:hover {
            color: #ff3333;
            text-decoration: underline;
            text-shadow: 0 0 10px rgba(255, 51, 51, 0.5);
        }
        /* ====== D E P R E S S E D  C L O W N ====== */
        .clown-wrapper {
            position: fixed;
            bottom: 30px;
            left: 30px;
            width: 180px;
            height: 180px;
            opacity: 0.22;
            filter: blur(0.6px);
            pointer-events: none;
            z-index: 2;
            animation: uneasy 6s infinite ease-in-out;
        }
        .clown-face {
            width: 100%;
            height: 100%;
            border-radius: 50%;
            background: radial-gradient(circle at top, #e0e0e0, #7a7a7a 60%, #2a2a2a);
            position: relative;
            box-shadow: inset 0 -25px 45px rgba(0,0,0,0.7), 0 0 80px rgba(255,0,0,0.15);
        }
        .eye {
            position: absolute;
            top: 58px;
            width: 26px;
            height: 36px;
            background: #050505;
            border-radius: 50%;
            box-shadow: inset 0 0 12px rgba(255,0,0,0.4);
        }
        .eye.left { left: 44px; transform: rotate(7deg); }
        .eye.right { right: 44px; transform: rotate(-7deg); }
        .nose {
            position: absolute;
            top: 98px;
            left: 50%;
            width: 26px;
            height: 18px;
            background: #4b0000;
            border-radius: 50%;
            transform: translateX(-50%);
        }
        .mouth {
            position: absolute;
            bottom: 38px;
            left: 50%;
            width: 92px;
            height: 42px;
            border-bottom: 4px solid #5c0000;
            border-radius: 0 0 100px 100px;
            transform: translateX(-50%) rotate(-3deg);
        }
        .mouth::after {
            content: "";
            position: absolute;
            top: 8px;
            left: 50%;
            width: 2px;
            height: 22px;
            background: #2a0000;
            transform: translateX(-50%);
        }
        @keyframes uneasy {
            0% { transform: scale(1); }
            50% { transform: scale(1.015); }
            100% { transform: scale(1); }
        }
        /* افکت خون */
        .blood-drip {
            position: fixed;
            top: -50px;
            width: 3px;
            height: 100px;
            background: linear-gradient(to bottom, #660000, #ff0000);
            animation: drip 3s infinite;
            z-index: 0;
        }
        @keyframes drip {
            0% { top: -50px; opacity: 0; }
            50% { opacity: 1; }
            100% { top: 100vh; opacity: 0; }
        }
    </style>
</head>
<body>
    <!-- افکت خون -->
    <div class="blood-drip" style="left: 10%; animation-delay: 0s;"></div>
    <div class="blood-drip" style="left: 30%; animation-delay: 1s;"></div>
    <div class="blood-drip" style="left: 70%; animation-delay: 2s;"></div>
    <div class="blood-drip" style="left: 90%; animation-delay: 0.5s;"></div>

    <!-- دلقک افسرده -->
    <div class="clown-wrapper">
        <div class="clown-face">
            <div class="eye left"></div>
            <div class="eye right"></div>
            <div class="nose"></div>
            <div class="mouth"></div>
        </div>
    </div>

    <div class="container">
        {{-- ✅ لینک بازگشت اصلاح شد --}}
        <a href="{{ route('admin.questions.index', $test->id) }}" class="back-link">
            ← بازگشت به لیست سوالات
        </a>

        <h1>🩸 ویرایش سوال</h1>

        <div class="test-info">
            <h2>تست: {{ $test->title }}</h2>
        </div>

        @if($errors->any())
            <div class="alert">
                <ul style="margin: 0; padding-right: 20px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        {{-- ✅ اکشن فرم اصلاح شد --}}
        <form action="{{ route('admin.questions.update', [$test->id, $question->id]) }}" method="POST">
            @csrf
            @method('PUT')

            {{-- متن سوال --}}
            <div class="form-group">
                <label for="text">متن سوال *</label>
                <textarea id="text" name="text" required placeholder="متن سوال را اینجا بنویسید...">{{ old('text', $question->text) }}</textarea>
                @error('text') <div class="error">{{ $message }}</div> @enderror
            </div>

            {{-- نوع سوال --}}
            <div class="form-group">
                <label>نوع سوال *</label>
                <div class="radio-group">
                    <label>
                        <input type="radio" name="type" value="multiple_choice" 
                               {{ old('type', $question->type) == 'multiple_choice' ? 'checked' : '' }}
                               onclick="toggleOptions(true)">
                        تستی (چندگزینه‌ای)
                    </label>
                    <label>
                        <input type="radio" name="type" value="text" 
                               {{ old('type', $question->type) == 'text' ? 'checked' : '' }}
                               onclick="toggleOptions(false)">
                        تشریحی
                    </label>
                </div>
                @error('type') <div class="error">{{ $message }}</div> @enderror
            </div>

            {{-- بخش گزینه‌ها --}}
            <div id="options-section" class="options-section">
                <h3>📝 گزینه‌های سوال</h3>
                <div id="options-container">
                    @if($question->options->count() > 0)
                        @foreach($question->options as $index => $option)
                            <div class="option-item">
                                <input type="text" name="options[{{ $index }}][text]" 
                                       value="{{ $option->text }}" 
                                       placeholder="متن گزینه {{ $index + 1 }}">
                                <input type="number" name="options[{{ $index }}][score_value]" 
                                       value="{{ $option->score_value }}" 
                                       placeholder="امتیاز" step="0.1">
                                <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
                            </div>
                        @endforeach
                    @else
                        <div class="option-item">
                            <input type="text" name="options[0][text]" placeholder="متن گزینه ۱">
                            <input type="number" name="options[0][score_value]" placeholder="امتیاز" step="0.1">
                            <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
                        </div>
                        <div class="option-item">
                            <input type="text" name="options[1][text]" placeholder="متن گزینه ۲">
                            <input type="number" name="options[1][score_value]" placeholder="امتیاز" step="0.1">
                            <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
                        </div>
                    @endif
                </div>
                <button type="button" class="btn-add" onclick="addOption()">➕ افزودن گزینه</button>
            </div>

            {{-- ترتیب نمایش --}}
            <div class="form-group">
                <label for="order">ترتیب نمایش *</label>
                <input type="number" id="order" name="order" 
                       value="{{ old('order', $question->order) }}" 
                       min="1" required>
                @error('order') <div class="error">{{ $message }}</div> @enderror
            </div>

            {{-- اجباری بودن --}}
            <div class="form-group">
                <div class="checkbox-group">
                    <input type="checkbox" id="is_required" name="is_required" value="1" 
                           {{ old('is_required', $question->is_required) ? 'checked' : '' }}>
                    <label for="is_required">پاسخ به این سوال اجباری باشد</label>
                </div>
            </div>

            {{-- فرمول مرتبط --}}
            @if($formulas->count() > 0)
            <div class="form-group">
                <label for="formula_id">فرمول مرتبط (اختیاری)</label>
                <select id="formula_id" name="formula_id">
                    <option value="">-- بدون فرمول --</option>
                    @foreach($formulas as $formula)
                        <option value="{{ $formula->id }}" 
                                {{ old('formula_id', $question->formula_id) == $formula->id ? 'selected' : '' }}>
                            {{ $formula->name }}
                        </option>
                    @endforeach
                </select>
                @error('formula_id') <div class="error">{{ $message }}</div> @enderror
            </div>
            @endif

            {{-- دکمه‌ها --}}
            <div class="btn-group">
                <button type="submit" class="btn btn-primary">💾 ذخیره تغییرات</button>
                {{-- ✅ دکمه انصراف اصلاح شد --}}
                <a href="{{ route('admin.questions.index', $test->id) }}" class="btn btn-secondary">❌ انصراف</a>
            </div>
        </form>
    </div>

    <script>
        function toggleOptions(show) {
            const section = document.getElementById('options-section');
            if (show) {
                section.classList.add('active');
            } else {
                section.classList.remove('active');
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            const selected = document.querySelector('input[name="type"]:checked');
            if (selected) {
                toggleOptions(selected.value === 'multiple_choice');
            }
        });

        function addOption() {
            const container = document.getElementById('options-container');
            const index = container.children.length;
            const div = document.createElement('div');
            div.className = 'option-item';
            div.innerHTML = `
                <input type="text" name="options[${index}][text]" placeholder="متن گزینه ${index + 1}">
                <input type="number" name="options[${index}][score_value]" placeholder="امتیاز" step="0.1">
                <button type="button" class="btn-remove" onclick="removeOption(this)">✕</button>
            `;
            container.appendChild(div);
        }

        function removeOption(btn) {
            btn.parentElement.remove();
        }
    </script>
</body>
</html>