<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ویرایش تست</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: Tahoma, Arial, sans-serif;
            background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
            min-height: 100vh;
            padding: 40px 20px;
            color: #fff;
        }
        .container { max-width: 700px; margin: 0 auto; }
        h1 { color: #00d9ff; margin-bottom: 30px; text-align: center; }
        
        .form-group { margin-bottom: 25px; }
        label { display: block; color: #00d9ff; margin-bottom: 8px; font-weight: bold; }
        input[type="text"], textarea {
            width: 100%;
            padding: 12px 15px;
            border-radius: 8px;
            border: 1px solid rgba(255,255,255,0.2);
            background: rgba(255,255,255,0.05);
            color: #fff;
            font-size: 14px;
        }
        input[type="text"]:focus, textarea:focus {
            outline: none;
            border-color: #00d9ff;
            box-shadow: 0 0 0 3px rgba(0, 217, 255, 0.2);
        }
        textarea { min-height: 120px; resize: vertical; }
        
        .checkbox-group {
            display: flex;
            align-items: center;
            gap: 10px;
            padding: 12px 15px;
            background: rgba(255,255,255,0.05);
            border-radius: 8px;
            border: 1px solid rgba(255,255,255,0.2);
        }
        .checkbox-group input { width: auto; }
        .checkbox-group label { margin: 0; color: #fff; font-weight: normal; }
        
        .btn-group { display: flex; gap: 15px; margin-top: 30px; }
        .btn {
            flex: 1;
            padding: 14px 20px;
            border-radius: 8px;
            border: none;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            transition: all 0.3s;
            text-align: center;
            text-decoration: none;
        }
        .btn-primary { background: #00d9ff; color: #000; }
        .btn-primary:hover { background: #00b8d9; transform: translateY(-2px); }
        .btn-secondary { background: rgba(255,255,255,0.1); color: #fff; }
        .btn-secondary:hover { background: rgba(255,255,255,0.2); }
        
        .error { color: #ff4444; font-size: 13px; margin-top: 5px; }
        .alert {
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
            background: rgba(255, 68, 68, 0.1);
            border-right: 4px solid #ff4444;
            color: #ff4444;
        }
        .back-link {
            display: inline-block;
            color: #00d9ff;
            margin-bottom: 20px;
            text-decoration: none;
        }
        .back-link:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class="container">
        <a href="{{ route('admin.tests.index') }}" class="back-link">← بازگشت به لیست تست‌ها</a>
        
        <h1>✏️ ویرایش تست</h1>

        @if($errors->any())
            <div class="alert">
                <ul style="margin: 0; padding-right: 20px;">
                    @foreach($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('admin.tests.update', $test->id) }}" method="POST">
            @csrf
            @method('PUT')  {{-- ← این خط برای متد PUT حیاتی است! --}}

            {{-- فیلد عنوان تست --}}
            <div class="form-group">
                <label for="title">عنوان تست *</label>
                <input type="text" 
                       id="title" 
                       name="title" 
                       value="{{ old('title', $test->title) }}"  {{-- ← مقدار از تست + old --}}
                       required 
                       placeholder="مثلاً: تست اضطراب بک">
                @error('title')
                    <div class="error">{{ $message }}</div>
                @enderror
            </div>

            {{-- فیلد توضیحات تست --}}
            <div class="form-group">
                <label for="description">توضیحات</label>
                <textarea id="description" 
                          name="description" 
                          placeholder="توضیحات کوتاه درباره این تست...">{{ old('description', $test->description) }}</textarea>
                @error('description')
                    <div class="error">{{ $message }}</div>
                @enderror
            </div>

            {{-- چک‌باکس وضعیت فعال/غیرفعال --}}
            <div class="form-group">
                <div class="checkbox-group">
                    <input type="checkbox" 
                           id="is_active" 
                           name="is_active" 
                           value="1" 
                           {{ old('is_active', $test->is_active) ? 'checked' : '' }}>
                    <label for="is_active">تست فعال باشد</label>
                </div>
            </div>

            {{-- دکمه‌های ارسال و انصراف --}}
            <div class="btn-group">
                <button type="submit" class="btn btn-primary">💾 ذخیره تغییرات</button>
                <a href="{{ route('admin.tests.index') }}" class="btn btn-secondary">❌ انصراف</a>
            </div>
        </form>
    </div>
    
</body>
</html>