<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>پنل مدیریت تست‌ها</title>

<style>
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: Tahoma, Arial, sans-serif;
    background:
        radial-gradient(circle at top, #2a0000 0%, #0a0a0f 60%, #000 100%);
    min-height: 100vh;
    padding: 40px 20px;
    color: #c7c7c7;
    overflow-x: hidden;
}

/* حس فشار */
body::after {
    content: "";
    position: fixed;
    inset: 0;
    background: rgba(0,0,0,0.35);
    pointer-events: none;
    z-index: 1;
}

.container {
    max-width: 1200px;
    margin: 0 auto;
    position: relative;
    z-index: 5;
}

h1 {
    text-align: center;
    font-size: 26px;
    color: #ff5c5c;
    letter-spacing: 2px;
    margin-bottom: 40px;
    text-shadow: 0 0 15px rgba(255, 92, 92, 0.4);
}

h1::after {
    content: "هیچ‌چیز اینجا ساده نیست";
    display: block;
    margin-top: 12px;
    font-size: 12px;
    color: #666;
    letter-spacing: 1px;
}

.btn {
    display: inline-block;
    padding: 12px 26px;
    border-radius: 4px;
    text-decoration: none;
    font-size: 13px;
    letter-spacing: 1px;
    transition: all 0.25s ease;
    border: 1px solid transparent;
}

.btn-primary {
    background: #1a1a1a;
    color: #ff5c5c;
    border-color: #ff5c5c;
}

.btn-primary:hover {
    background: #ff5c5c;
    color: #000;
}

.btn-success {
    background: #1b2a2a;
    color: #9fd3c7;
    border: 1px solid #355;
    font-size: 11px;
    padding: 6px 12px;
}

.btn-warning {
    background: #2a241b;
    color: #ffcc88;
    border: 1px solid #554;
    font-size: 11px;
    padding: 6px 12px;
}

.btn-danger {
    background: #2a0000;
    color: #ff8c8c;
    border: 1px solid #660000;
    font-size: 11px;
    padding: 6px 12px;
}

.btn-danger:hover {
    background: #660000;
}

table {
    width: 100%;
    border-collapse: collapse;
    background: rgba(0, 0, 0, 0.6);
    box-shadow:
        inset 0 0 40px rgba(255, 0, 0, 0.08),
        0 20px 60px rgba(0, 0, 0, 0.9);
}

thead {
    background: rgba(80, 0, 0, 0.6);
}

th {
    padding: 16px;
    text-align: right;
    color: #ff8c8c;
    font-weight: normal;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
}

td {
    padding: 16px;
    color: #b0b0b0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.04);
}

tr:hover {
    background: rgba(255, 0, 0, 0.05);
}

.actions {
    display: flex;
    gap: 6px;
    flex-wrap: wrap;
}

.alert {
    padding: 15px;
    margin-bottom: 25px;
    background: rgba(255, 0, 0, 0.08);
    border-right: 4px solid #ff5c5c;
    color: #ffb3b3;
}

.empty-state {
    text-align: center;
    padding: 90px 20px;
    color: #777;
}

.empty-state h2 {
    color: #ff5c5c;
    font-weight: normal;
    margin-bottom: 10px;
}

.status-active {
    color: #8affc1;
}

.status-inactive {
    color: #ff6b6b;
}

/* ====== D E P R E S S E D  C L O W N ====== */

.clown-wrapper {
    position: fixed;
    bottom: 30px;
    left: 30px;
    width: 180px;
    height: 180px;
    opacity: 0.22;
    filter: blur(0.6px);
    pointer-events: none;
    z-index: 2;
    animation: uneasy 6s infinite ease-in-out;
}

.clown-face {
    width: 100%;
    height: 100%;
    border-radius: 50%;
    background: radial-gradient(circle at top, #e0e0e0, #7a7a7a 60%, #2a2a2a);
    position: relative;
    box-shadow:
        inset 0 -25px 45px rgba(0,0,0,0.7),
        0 0 80px rgba(255,0,0,0.15);
}

.eye {
    position: absolute;
    top: 58px;
    width: 26px;
    height: 36px;
    background: #050505;
    border-radius: 50%;
    box-shadow: inset 0 0 12px rgba(255,0,0,0.4);
}

.eye.left { left: 44px; transform: rotate(7deg); }
.eye.right { right: 44px; transform: rotate(-7deg); }

.nose {
    position: absolute;
    top: 98px;
    left: 50%;
    width: 26px;
    height: 18px;
    background: #4b0000;
    border-radius: 50%;
    transform: translateX(-50%);
}

.mouth {
    position: absolute;
    bottom: 38px;
    left: 50%;
    width: 92px;
    height: 42px;
    border-bottom: 4px solid #5c0000;
    border-radius: 0 0 100px 100px;
    transform: translateX(-50%) rotate(-3deg);
}

.mouth::after {
    content: "";
    position: absolute;
    top: 8px;
    left: 50%;
    width: 2px;
    height: 22px;
    background: #2a0000;
    transform: translateX(-50%);
}

@keyframes uneasy {
    0% { transform: scale(1); }
    50% { transform: scale(1.015); }
    100% { transform: scale(1); }
}
</style>
</head>

<body>

<div class="clown-wrapper">
    <div class="clown-face">
        <div class="eye left"></div>
        <div class="eye right"></div>
        <div class="nose"></div>
        <div class="mouth"></div>
    </div>
</div>

<div class="container">
    <h1>پنل مدیریت تست‌ها</h1>

    @if(session('success'))
        <div class="alert">{{ session('success') }}</div>
    @endif

    <a href="{{ route('admin.tests.create') }}" class="btn btn-primary">
        ساخت تست جدید
    </a>

    @if($tests->count() > 0)
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>عنوان تست</th>
                    <th>توضیحات</th>
                    <th>وضعیت</th>
                    <th>عملیات</th>
                </tr>
            </thead>
            <tbody>
            @foreach($tests as $test)
                <tr>
                    <td>{{ $test->id }}</td>
                    <td style="color:#fff">{{ $test->title }}</td>
                    <td>{{ Str::limit($test->description, 50) ?? '—' }}</td>
                    <td>
                        @if($test->is_active)
                            <span class="status-active">فعال</span>
                        @else
                            <span class="status-inactive">غیرفعال</span>
                        @endif
                    </td>
                    <td>
                        <div class="actions">
                            <a href="{{ route('admin.tests.edit', $test->id) }}" class="btn btn-warning">ویرایش</a>
                            <a href="{{ route('admin.questions.index', $test->id) }}" class="btn btn-success">سوالات</a>
                            <a href="{{ route('admin.formulas.index', $test->id) }}" class="btn btn-success">فرمول‌ها</a>
                            <form action="{{ route('admin.tests.destroy', $test->id) }}" method="POST" style="display:inline"
                                  onsubmit="return confirm('این تصمیم بازگشتی ندارد. مطمئنی؟')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">حذف</button>
                            </form>
                        </div>
                    </td>
                </tr>
            @endforeach
            </tbody>
        </table>
    @else
        <div class="empty-state">
            <h2>هیچ‌چیز اینجا نیست</h2>
            <p>و شاید بهتر همین‌طور بماند</p>
            <br>
            <a href="{{ route('admin.tests.create') }}" class="btn btn-primary">شروع</a>
        </div>
    @endif
</div>

</body>
</html>
