<?php

use App\Http\Controllers\Admin;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\TestController;
use App\Http\Controllers\Admin\AdminTestController;
use App\Http\Controllers\Admin\AdminFormulaController;
use App\Http\Controllers\Admin\FormulaResultController;
use App\Http\Controllers\Admin\AdminQuestionController;
use App\Http\Controllers\TestTakingController;
// نمایش فرم تست
Route::get('/tests/{test}', [TestController::class, 'show'])->name('tests.show');

// ثبت پاسخ‌ها
//Route::post('/tests/{test}/submit', [TestController::class, 'submit'])->name('tests.submit');

Route::get('/hello', function() {
    return response()->json(['message' => 'Hello World!']);
});


Route::prefix('admin')->name('admin.')->group(function () {

    // ─────────────────────────────────────────────────────────────
    // ۱. مدیریت تست‌ها (Tests)
    // ─────────────────────────────────────────────────────────────
    Route::get('/tests', [AdminTestController::class, 'index'])->name('tests.index');
    Route::get('/tests/create', [AdminTestController::class, 'create'])->name('tests.create');
    Route::post('/tests', [AdminTestController::class, 'store'])->name('tests.store');
    Route::get('/tests/{test}/edit', [AdminTestController::class, 'edit'])->name('tests.edit');
    Route::put('/tests/{test}', [AdminTestController::class, 'update'])->name('tests.update');
    Route::delete('/tests/{test}', [AdminTestController::class, 'destroy'])->name('tests.destroy');

    // ─────────────────────────────────────────────────────────────
    // ۲. مدیریت سوالات (Questions)
    // ─────────────────────────────────────────────────────────────
    Route::get('/tests/{test}/questions', [AdminQuestionController::class, 'questions'])->name('questions.index');
    Route::get('/tests/{test}/questions/create', [AdminQuestionController::class, 'create'])->name('questions.create');
    Route::post('/tests/{test}/questions', [AdminQuestionController::class, 'store'])->name('questions.store');
    Route::get('/tests/{test}/questions/{question}/edit', [AdminQuestionController::class, 'edit'])->name('questions.edit');
    Route::put('/tests/{test}/questions/{question}', [AdminQuestionController::class, 'update'])->name('questions.update');
    Route::delete('/tests/{test}/questions/{question}', [AdminQuestionController::class, 'destroy'])->name('questions.destroy');
    // ─────────────────────────────────────────────────────────────
    // ۳. مدیریت گزینه‌ها (Options)
    // ─────────────────────────────────────────────────────────────
    Route::post('/tests/{test}/questions/{question}/options', [AdminTestController::class, 'storeOption'])->name('tests.questions.options.store');
    Route::put('/tests/{test}/questions/{question}/options/{option}', [AdminTestController::class, 'updateOption'])->name('tests.questions.options.update');
    Route::delete('/tests/{test}/questions/{question}/options/{option}', [AdminTestController::class, 'destroyOption'])->name('tests.questions.options.destroy');

    // ─────────────────────────────────────────────────────────────
    // ۴. مدیریت فرمول‌ها (Formulas)
    // ─────────────────────────────────────────────────────────────
    Route::get('/tests/{test}/formulas', [AdminFormulaController::class, 'index'])->name('formulas.index');
    Route::get('/tests/{test}/formulas/create', [AdminFormulaController::class, 'create'])->name('formulas.create');
    Route::post('/tests/{test}/formulas', [AdminFormulaController::class, 'store'])->name('formulas.store');
    Route::get('/tests/{test}/formulas/{formula}/edit', [AdminFormulaController::class, 'edit'])->name('formulas.edit');
    Route::put('/tests/{test}/formulas/{formula}', [AdminFormulaController::class, 'update'])->name('formulas.update');
    Route::delete('/tests/{test}/formulas/{formula}', [AdminFormulaController::class, 'destroy'])->name('formulas.destroy');
    // ─────────────────────────────────────────────────────────────
    // ۵. انتساب فرمول به سوالات
    // ─────────────────────────────────────────────────────────────
    //Route::get('/tests/{test}/assign-formulas', [AdminTestController::class, 'assignFormulas'])->name('tests.assign-formulas');
    //Route::post('/tests/{test}/assign-formulas', [AdminTestController::class, 'storeAssignFormulas'])->name('tests.assign-formulas.store');
    Route::get('/tests/{testId}/formula-results', [App\Http\Controllers\Admin\FormulaResultController::class, 'index']);
    Route::get('/tests/{testId}/formula-results/{attemptId}', [App\Http\Controllers\Admin\FormulaResultController::class, 'show']);
});

Route::get('/test-controller', function() {
    // تست بدون دیتابیس
    $fakeTest = new stdClass();
    $fakeTest->title = 'تست ساختگی';
    $fakeTest->id = 1;

    $fakeResults = collect([]);
    $fakeAttemptId = 45;

    return view('admin.formula-results.show', [
        'test' => $fakeTest,
        'attemptId' => $fakeAttemptId,
        'results' => $fakeResults,
    ]);
});

Route::get('/tests/{test}/formula-results', [App\Http\Controllers\Admin\FormulaResultController::class, 'index'])->name('formula-results.index');
Route::get('/tests/{test}/formula-results/{attemptId}', [App\Http\Controllers\Admin\FormulaResultController::class, 'show'])->name('formula-results.show');

Route::get('/test-direct', function() {
    return view('test-direct');
});


Route::get('/test-submit', function() {
    $controller = new \App\Http\Controllers\TestTakingController(
        new \App\Calculators\FormulaCalculator()
    );

    $request = new \Illuminate\Http\Request();
    $request->setMethod('POST');
    $request->merge([
        'participant_name' => 'تست مرورگر',
        'participant_phone' => '09120000000',
        'answers' => [
            ['question_id' => 1, 'option_id' => 1],
        ]
    ]);

    $test = \App\Models\Test::find(1);

    return $controller->submit($request, $test);
});
Route::get('/debug-formula-test', function() {

    // ۱. پیدا کردن تست و داده‌های واقعی
    $test = \App\Models\Test::first();
    if (!$test) return response()->json(['error' => 'No test found'], 404);

    $question = \App\Models\Question::where('test_id', $test->id)->first();
    $option = \App\Models\Option::where('question_id', $question->id ?? 1)->first();

    if (!$question || !$option) {
        return response()->json(['error' => 'No question/option found'], 404);
    }

    // ۲. ساخت درخواست واقعی
    $request = request()->create('/tests/' . $test->id . '/submit', 'POST', [
        'participant_name' => 'کاربر تست',
        'participant_phone' => '09120000000',
        'answers' => [
            ['question_id' => $question->id, 'option_id' => $option->id, 'text_answer' => null]
        ]
    ]);

    // ۳. اجرای کنترلر
    $controller = new \App\Http\Controllers\TestTakingController(
        new \App\Calculators\FormulaCalculator()
    );

    try {
        $response = $controller->submit($request, $test);
        return $response; // ← پاسخ JSON را مستقیم برمی‌گرداند
    } catch (\Throwable $e) {
        return response()->json([
            'error' => $e->getMessage(),
            'file' => $e->getFile() . ':' . $e->getLine(),
            'trace' => explode("\n", $e->getTraceAsString())
        ], 500);
    }
});
Route::get('/debug-formula-references', function() {
    $calculator = new \App\Calculators\FormulaCalculator();

    // تست ۱: جایگزینی ساده
    $result1 = $calculator->calculate(
        '{MATH_ADD} * 2',
        [],  // variables
        ['MATH_ADD' => ['success' => true, 'value' => 3]]  // formulaResults
    );

    // تست ۲: جایگزینی با رشته
    $result2 = $calculator->calculate(
        '{STR_RESULT} . "_test"',
        [],
        ['STR_RESULT' => ['success' => true, 'value' => 'hello']]
    );

    // تست ۳: بدون formulaResults (باید کاراکتر { باقی بماند و خطا دهد)
    $result3 = $calculator->calculate(
        '{MATH_ADD} * 2',
        [],
        []  // خالی!
    );

    return response()->json([
        'test1_simple' => $result1,
        'test2_string' => $result2,
        'test3_empty_results' => $result3,
    ]);
});

