<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>جزئیات کامل تست - اجرای #<?php echo e($attempt->id); ?></title>
    <style>
        * { box-sizing: border-box; }
        body { font-family: Tahoma, Vazir, sans-serif; background: #f5f5f5; padding: 20px; margin: 0; line-height: 1.6; }
        .container { max-width: 1400px; margin: 0 auto; }
        .section { background: #fff; padding: 20px; border-radius: 8px; margin-bottom: 20px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .section-title { font-size: 18px; font-weight: bold; margin-bottom: 15px; padding-bottom: 10px; border-bottom: 2px solid #007bff; color: #333; }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .header h1 { margin: 0; font-size: 22px; }
        .btn { display: inline-block; padding: 8px 16px; background: #6c757d; color: #fff; border-radius: 4px; text-decoration: none; }
        .btn:hover { background: #5a6268; text-decoration: none; }

        /* جدول‌ها */
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { padding: 12px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #f8f9fa; font-weight: bold; color: #333; }
        tr:hover { background: #f9f9f9; }

        /* Badgeها */
        .badge { padding: 4px 10px; border-radius: 4px; font-size: 11px; display: inline-block; }
        .badge-code { background: #cce5ff; color: #004085; }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-error { background: #f8d7da; color: #721c24; }

        /* رنگ‌ها */
        .text-success { color: #28a745; font-weight: bold; }
        .text-error { color: #dc3545; }
        .text-muted { color: #666; }
        .text-primary { color: #007bff; }

        /* اطلاعات شرکت‌کننده */
        .info-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; }
        .info-item { background: #f8f9fa; padding: 12px; border-radius: 6px; }
        .info-item small { display: block; color: #666; font-size: 12px; margin-bottom: 4px; }
        .info-item strong { font-size: 14px; color: #333; }

        /* سوالات */
        .question-card { background: #fafafa; border: 1px solid #e0e0e0; border-radius: 6px; padding: 15px; margin-bottom: 12px; }
        .question-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .question-number { background: #007bff; color: #fff; width: 28px; height: 28px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: bold; }
        .question-score { font-size: 13px; color: #28a745; font-weight: bold; }
        .question-text { font-size: 14px; margin-bottom: 10px; color: #333; }
        .answer-detail { font-size: 13px; color: #666; }
        .answer-detail span { color: #007bff; font-weight: bold; }

        /* فرمول‌ها */
        .formula-card { background: #fff; border: 1px solid #e0e0e0; border-radius: 6px; padding: 15px; margin-bottom: 12px; }
        .formula-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 10px; }
        .formula-expression { font-family: 'Courier New', monospace; background: #f5f5f5; padding: 10px; border-radius: 4px; font-size: 13px; direction: ltr; text-align: left; margin: 10px 0; }
        .formula-input { font-size: 12px; color: #666; margin: 8px 0; }
        .formula-result { font-size: 16px; font-weight: bold; }

        /* اسکرول افقی برای جدول‌های بزرگ */
        .table-responsive { overflow-x: auto; }
    </style>
</head>
<body>
<div class="container">
    
    <div class="header">
        <div>
            <h1>📊 جزئیات کامل تست</h1>
            <p style="margin: 5px 0 0 0; color: #666;">
                تست: <?php echo e($test->title); ?> | اجرای شماره: <?php echo e($attempt->id); ?>

            </p>
        </div>
        <a href="/tests/<?php echo e($test->id); ?>/formula-results" class="btn">← بازگشت به لیست</a>
    </div>

    
    <div class="section">
        <div class="section-title">👤 اطلاعات شرکت‌کننده</div>
        <div class="info-grid">
            <div class="info-item">
                <small>نام</small>
                <strong><?php echo e($attempt->participant_name ?? '-'); ?></strong>
            </div>
            <div class="info-item">
                <small>شماره تماس</small>
                <strong><?php echo e($attempt->participant_phone ?? '-'); ?></strong>
            </div>
            <div class="info-item">
                <small>نمره کل سوالات</small>
                <strong class="text-success"><?php echo e($attempt->total_score); ?></strong>
            </div>
            <div class="info-item">
                <small>تاریخ اجرا</small>
                <strong><?php echo e($attempt->created_at?->format('Y/m/d H:i') ?? '-'); ?></strong>
            </div>
        </div>
    </div>

    
    <div class="section">
        <div class="section-title">📝 سوالات و پاسخ‌های کاربر</div>
        <div class="table-responsive">
            <table>
                <thead>
                <tr>
                    <th style="width: 50px;">#</th>
                    <th>سوال</th>
                    <th>پاسخ کاربر</th>
                    <th>امتیاز سوال</th>
                </tr>
                </thead>
                <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $answers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $answer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($index + 1); ?></td>
                        <td><?php echo e($answer->question->text ?? 'سوال حذف شده'); ?></td>
                        <td>
                            <?php if($answer->option_id): ?>
                                <span class="text-primary">
                                    <?php echo e($answer->question->options->firstWhere('id', $answer->option_id)->text ?? 'گزینه حذف شده'); ?>

                                </span>
                            <?php elseif($answer->text_answer): ?>
                                <span class="text-muted"><?php echo e($answer->text_answer); ?></span>
                            <?php else: ?>
                                <span class="text-error">بدون پاسخ</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php if($answer->option_id): ?>
                                <?php
                                    $option = $answer->question->options->firstWhere('id', $answer->option_id);
                                    $score = $option?->score_value ?? 0;
                                ?>
                                <span class="<?php echo e($score > 0 ? 'text-success' : 'text-muted'); ?>">
                                    <?php echo e($score); ?>

                                </span>
                            <?php else: ?>
                                <span class="text-muted">0</span>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr><td colspan="4" style="text-align: center; padding: 20px; color: #666;">پاسخی یافت نشد</td></tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
    <div class="section">
        <div class="section-title">🧮 محاسبات فرمول‌ها</div>

        <?php $__empty_1 = true; $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="formula-card">
                <div class="formula-header">
                    <div>
                        <span class="badge badge-code"><?php echo e($result->formula_code); ?></span>
                        <span style="margin-right: 10px; color: #666;">
                        <?php echo e($formulas[$result->formula_id]->name ?? 'فرمول نامشخص'); ?>

                    </span>
                    </div>
                    <div>
                        <?php if($result->result_value !== null): ?>
                            <span class="badge badge-success">✅ موفق</span>
                        <?php else: ?>
                            <span class="badge badge-error">❌ خطا</span>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="formula-expression">
                    <strong>معادله:</strong> <?php echo e($result->expression_snapshot); ?>

                </div>

                <div class="formula-input">
                    <strong>مقادیر ورودی:</strong>
                    <code style="direction: ltr; display: inline-block;">
                        <?php echo e(json_encode($result->input_values ?? [], JSON_UNESCAPED_UNICODE)); ?>

                    </code>
                </div>

                <div class="formula-result">
                    <strong>نتیجه نهایی:</strong>
                    <?php if($result->result_value !== null): ?>
                        <span class="text-success" style="font-size: 20px;">
                        <?php echo e($result->result_value); ?>

                    </span>
                        <span class="text-muted" style="font-size: 12px;">(<?php echo e($result->result_type); ?>)</span>
                    <?php else: ?>
                        <span class="text-error">محاسبه نشد</span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <p style="text-align: center; color: #666; padding: 20px;">هیچ نتیجه‌ای برای این اجرا یافت نشد</p>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
<?php /**PATH C:\Users\User\Desktop\psychology-test(2)\psychology-test\resources\views/admin/formula-results/show.blade.php ENDPATH**/ ?>