<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>نتایج فرمول‌ها</title>
    <style>
        body { font-family: Tahoma; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1200px; margin: 0 auto; background: #fff; padding: 20px; border-radius: 8px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { padding: 10px; text-align: right; border-bottom: 1px solid #eee; }
        th { background: #f8f8f8; }
        .badge { padding: 4px 8px; border-radius: 4px; font-size: 11px; }
        .badge-code { background: #cce5ff; color: #004085; }
        .badge-success { background: #d4edda; color: #155724; }
        .text-success { color: #28a745; font-weight: bold; }
        .text-error { color: #dc3545; }
        a { color: #007bff; }
    </style>
</head>
<body>
<div class="container">
    <h1>نتایج فرمول‌های تست: <?php echo e($test->title); ?></h1>

    <h2>لیست فرمول‌ها</h2>
    <table>
        <thead>
        <tr>
            <th>کد</th>
            <th>نام</th>
            <th>فرمول</th>
            <th>نتیجه</th>
            <th>وضعیت</th>
        </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $formulas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formula): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php $result = $latestResults[$formula->code]->first() ?? null; ?>
            <tr>
                <td><span class="badge badge-code"><?php echo e($formula->code); ?></span></td>
                <td><?php echo e($formula->name); ?></td>
                <td style="font-family: monospace;"><?php echo e($formula->formula_expression); ?></td>
                <td>
                    <?php if($result && $result->result_value !== null): ?>
                        <span class="text-success"><?php echo e($result->result_value); ?></span>
                    <?php elseif($result): ?>
                        <span class="text-error">خطا</span>
                    <?php else: ?>
                        <span style="color: #999;">هنوز اجرا نشده</span>
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($result && $result->result_value !== null): ?>
                        <span class="badge badge-success">✅ موفق</span>
                    <?php elseif($result): ?>
                        <span class="badge badge-error" style="background: #f8d7da; color: #721c24;">❌ خطا</span>
                    <?php else: ?>
                        <span class="badge" style="background: #fff3cd; color: #856404;">⏳ در انتظار</span>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr><td colspan="5" style="text-align: center; padding: 20px;">هیچ فرمولی وجود ندارد</td></tr>
        <?php endif; ?>
        </tbody>
    </table>

    <?php if($attempts->count() > 0): ?>
        <h2 style="margin-top: 30px;">اجراهای اخیر</h2>
        <table>
            <thead>
            <tr>
                <th>ID اجرا</th>
                <th>شرکت‌کننده</th>
                <th>نمره کل</th>
                <th>عملیات</th>
            </tr>
            </thead>
            <tbody>
            <?php $__currentLoopData = $attempts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attempt): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($attempt->id); ?></td>
                    <td><?php echo e($attempt->participant_name); ?></td>
                    <td><?php echo e($attempt->total_score); ?></td>
                    <td>
                        <a href="/tests/<?php echo e($test->id); ?>/formula-results/<?php echo e($attempt->id); ?>">مشاهده جزئیات →</a>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php endif; ?>

    <p style="margin-top: 20px;"><a href="/tests">← بازگشت به لیست تست‌ها</a></p>
</div>
</body>
</html>
<?php /**PATH C:\Users\User\Desktop\psychology-test(2)\psychology-test\resources\views/admin/formula-results/index.blade.php ENDPATH**/ ?>